#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Oil on the WaterMod01.fsh  by   Kali
//https://www.shadertoy.com/view/4tfGzj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime*.05


#define width .2

float thick=0.;
float pix;
float zoom = .5;


float formula(vec2 z) {
	float ot=1000.;
	for (int i=0; i<11; i++) {
		float dz=dot(z,z);
		z=abs(z*2.)/dz-1.;
		ot=min(ot,dz);
	}
	float h=.014/(max(0.,width-ot)/width*.9+.1);
	thick+=max(0.,1.-h);
	return h;
}

vec3 normal(vec2 z) {
	vec2 d=vec2(pix,0.);
	vec3 n=normalize(cross( //get normal
	vec3(d.x*2.,0.,formula(z-d.xy)-formula(z+d.xy)),
	vec3(0.,d.x*2.,formula(z-d.yx)-formula(z+d.yx))));
	return n;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 pos = fragCoord.xy / iResolution.xy;
	vec2 uv=pos-.5;
	uv.x*=iResolution.x/iResolution.y;
	zoom*=1.+sin(time*2.)*.5;
	vec2 luv=uv;
	uv+=vec2(sin(time),cos(time))*2.;
	uv+=sin(uv*30.+time*200.)*.0015;
	uv*=zoom;
	luv*=zoom;
	pix=1./iResolution.x*zoom;
	vec2 d=vec2(pix,0.);
	vec3 n= normal(uv-d.xy)+normal(uv+d.xy);
	     n+=normal(uv-d.yx)+normal(uv+d.yx);
		 n/=4.;
	thick/=16.;
	vec2 refr=-n.xy*.08;
	vec3 tex=texture2D(texture0,((uv+refr)*3.+vec2(time,0.))).xyz+.75;
	vec3 colo=tex*mix(vec3(.35,.55,1.)*2.5,vec3(1.,.65,.15)*.25,sqrt(thick));	
	vec3 lightdir=normalize(vec3(1.,.5,2.));
	colo+=max(0.,dot(-n,lightdir))*.4;
	colo+=pow(max(0.,dot(reflect(-n,vec3(0.,0.,-1.)),lightdir)),50.)*.6;
	colo+=pow(max(0.,dot(reflect(vec3(0.,0.,-1.),-n),lightdir)),50.)*.2;
	colo=pow(colo,vec3(1.5))*2.;
	fragColor = vec4(colo,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

